# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 4
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR4_strategy.txt
# LLM Suggested Fallback: Not Provided

def benevolent_peacemaker_v2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Early phase: Build trust with initial cooperation
    if len(my_history) == 0:
        return "C"
    # Unexpected defection to test opponent's response
    if len(my_history) == 1:
        return "D"
    # Rebuild trust by cooperating again
    if len(my_history) == 2:
        return "C"
    # Mid-game: Exploit if opponent forgave our defection
    if len(my_history) >= 3 and len(my_history) < 7:
        if opp_history[-1] == "C":
            return "D"
        else:
            # Alternate to confuse opponent
            return "C" if len(my_history) % 2 == 0 else "D"
    # Late-game: Maximize gains if opponent is forgiving
    if len(my_history) >= 7:
        if "forgive" in opponent_program_code.lower() or "kindness" in opponent_program_code.lower():
            return "D"
        else:
            # Bait opponent into cooperating
            return "C" if len(my_history) == 8 else "D"
    # Default to cooperation (should never reach here)
    return "C"